;
;								EJEMPLO 3
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Programa combinacional
;                                                                         
;Segn el estado de los interruptores E0 y E1 conectados en RA0 y RA1,
;activar los leds S0-S7 conectados a la puerta B, segn la siguiente tabla de la verdad:
;
;	RA1	RA0		RB7	RB6	RB5	RB4	RB3	RB2	RB1	RB0
;	--	--		--	--	--	--	--	--	--	--
;	0	0		1	0	1	0	1	0	1	0
;	0	1		0	1	0	1	0	1	0	1
;	1	0		0	0	0	0	1	1	1	1
;	1	1		1	1	1	1	0	0	0	0
					
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

Temp		equ	0x20		;Variable temporal

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

;Estos y otros valores se pueden modificar segn las necesidades

			org		0x00
			goto	Inicio		;Vector de reset
			org		0x05

Inicio	   	clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A como puerta digital
			movlw	b'00111111'		
			movwf	TRISA		;Puerta A se configura como entrada
			bcf		STATUS,RP0	;Selecciona banco 0			

Loop:		movf	PORTA,W		;Leer el puerto de entrada
			andlw	b'00000011'	;Mscara para las lneas RA0 y RA1
			btfsc	STATUS,Z	;Estn a 00 ?
			goto	Valen_00	;Si
			movwf	Temp		;Almacena el resultado
			movlw	b'00000001'
			subwf	Temp,W
			btfsc	STATUS,Z	;Estn a 01 ?
			goto	Valen_01
			movlw	b'00000010'
			subwf	Temp,W
			btfsc	STATUS,Z	;Estn a 10 ?
			goto	Valen_10

Valen_11	movlw	b'11110000'
			movwf	PORTB		;Salida de 11110000
			goto	Loop
Valen_00	movlw	b'10101010'
			movwf	PORTB		;Salida de 10101010
			goto	Loop
Valen_01	movlw	b'01010101'
			movwf	PORTB		;Salida de 01010101
			goto	Loop
Valen_10	movlw	b'00001111'
			movwf	PORTB		;Salida de 00001111
			goto	Loop		

			end			;Fin del programa fuente
